/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityEnt;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTreant
extends BaseCreatureEntity
implements IMob,
IGroupHeavy {
    public EntityTreant(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsUnderground = false;
        this.hasAttackSound = true;
        this.spreadFire = true;
        this.solidCollision = true;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
        this.field_70138_W = 2.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70086_ai() >= 0) {
            if (this.func_70090_H()) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 1));
            } else if (this.waterContact()) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 0));
            }
        }
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase target) {
        if (target instanceof EntityEnt) {
            return false;
        }
        return super.canAttackEntity(target);
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        float leeching = Math.max(1.0f, this.getAttackDamage(damageScale));
        this.func_70691_i(leeching);
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        if (damageSrc.func_76346_g() != null) {
            EntityLivingBase entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof EntityLivingBase && !(entityLiving = (EntityLivingBase)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
            }
            if (ObjectLists.isAxe(heldItem)) {
                return 2.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    public boolean petControlsEnabled() {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        if ("Wicked Treant".equals(this.func_95999_t())) {
            String textureName = this.getTextureName() + "_wicked";
            if (AssetManager.getTexture(textureName) == null) {
                AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
            }
            return AssetManager.getTexture(textureName);
        }
        if ("Salty Tree".equals(this.func_95999_t())) {
            String textureName = this.getTextureName() + "_saltytree";
            if (AssetManager.getTexture(textureName) == null) {
                AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
            }
            return AssetManager.getTexture(textureName);
        }
        return super.getTexture();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(50.0, 20.0, 50.0).func_72317_d(0.0, -10.0, 0.0);
    }
}

